<?
/*
PeHe.net RSS Reader 1.0
Copyright (C) Petr Heller 2004
Tato tda slou ke ten RSS dokumentu

Ukzku mete vyzkouet na adrese www.pehe.net

Dal ti tdy popisuj logo, jednotliv poloky, a kanly

Verze 1.0 um pest pouze jeden channel v rss souboru.

Nvod: pi vytven instance se mus zadat do kontruktoru nzev RSS souboru (ppadn vstupn kodovn)
pak u se jenom pomoc tdy jednodue zjiuj informace z RSS souboru

Pro pevod mezi znakovmi sadami je poteba knihovna ICONV
*/

//vrt obsah umstn mezi potenm a koncovm tagem
function ContentElement($string,$starttag,$endtag) {

 //nejprve vypoteme dlky tag
 $len_starttag=strlen($starttag);
 $len_endtag=strlen($endtag);

 //pozice potenho tagu
 $poz_starttag=strpos($string,$starttag);

 //v sti za potenm tagem najdeme koncov tag
 $poz_endtag=strpos($string,$endtag,$poz_starttag+$len_starttag);

 //vnitek obou tag, zjiujeme pozici prvnho znaku po potenm tagu a dlku vnitku tag
 $obsah=substr($string,$poz_starttag+$len_starttag,$poz_endtag-$poz_starttag-$len_endtag+1);

 return $obsah;
}

//tda informac o RSS kanlu 
class clsRSS {
  var $rsssoubor;

  //do konstruktoru se nastav cesta k RSS souboru; vytvome promnnou, jejm obsahem je obsah RSS kanlu
  function clsRSS($cesta,$vystupnikodovani="") {
    //kontrola existence souboru. Nelze pout file_exists() - neum pistupovat ke vzdlenm souborm
    if (!@fclose(@fopen("$cesta", "r"))) {
      die ("RSS kanl ".$cesta." nelze otevt.");
    }

    $this->$rsssoubor=implode("",@file($cesta));

    //verze XML a kodovn
    $xmlcontent=ContentElement($this->$rsssoubor,"xml",">");
    $this->XMLver=ContentElement($xmlcontent,"version=\"","\"");
    $this->Encoding=ContentElement($xmlcontent,"encoding=\"","\"");

    //verze RSS
    $rsscontent=ContentElement($this->$rsssoubor,"<rss",">");
    $this->RSSver=ContentElement($rsscontent,"version=\"","\"");

    //pevod do zadanho kodovn
    if ($vystupnikodovani!="") {
      $r=iconv($this->Encoding."//TRANSLIT", $vystupnikodovani."//TRANSLIT", $this->$rsssoubor);
      if ($r) {
        $this->$rsssoubor=$r;
      }
    }

    //titulek RSS kanlu
    $this->Title=ContentElement($this->$rsssoubor,"<title>","</title>");
    //cesta ke zdroji RSS kanlu
    $this->Link=ContentElement($this->$rsssoubor,"<link>","</link>");
    //popis RSS kanlu
    $this->Description=ContentElement($this->$rsssoubor,"<description>","</description>");
    //jazyk RSS kanlu
    $this->Language=ContentElement($this->$rsssoubor,"<language>","</language>");
    //copyrigh RSS kanlu
    $this->Copyright=ContentElement($this->$rsssoubor,"<copyright>","</copyright>");
    //den RSS kanlu
    $this->Day=ContentElement($this->$rsssoubor,"<day>","</day>");
    //hodina RSS kanlu
    $this->Hour=ContentElement($this->$rsssoubor,"<hour>","</hour>");
    //datum posledn modifikace RSS kanlu
    $this->LastBuiltDate=ContentElement($this->$rsssoubor,"<lastbuiltdate>","</lastbuiltdate>");
    //email danho webu
    $this->ManagingEditor=ContentElement($this->$rsssoubor,"<managingeditor>","</managingeditor>");
    //objekt logo webu
    $str=ContentElement($this->$rsssoubor,"<image>","</image>");
    $this->Image=new clsImage($str);


    //nyn zbv vytvoit pole poloek
    //to provedem tak, a vdy odtrhneme st ped <item>
    
    $pocetitemu=substr_count($this->$rsssoubor,"<item>");
    $odriznuto=$this->$rsssoubor;

    for ($p=1; $p<=$pocetitemu; $p++){
      $str=ContentElement($odriznuto,"<item>","</item>");
      $pole[$p] = new clsItem($str);

      $pozitemu=strpos($odriznuto,"<item>")+6;
      $odriznuto=substr($odriznuto,$pozitemu);
    }

    $this->Item=$pole;

  }
}

//tda popisujc obrzek (logo) RSS kanlu
class clsImage {
  var $imagestring; //obsah elementu obrzku

  //konstruktor, parametr je obsah elementu <image> vythnut z RSS souboru
  function clsImage($str) {
    $this->$imagestring=$str;

    //titulek obrzku (max 100 zn.)
    $this->Title=ContentElement($this->$imagestring,"<title>","</title>");
    //URL obrzku (max 500 zn.)
    $this->Link=ContentElement($this->$imagestring,"<link>","</link>");
    //popis obrzku
    $this->Description=ContentElement($this->$imagestring,"<description>","</description>");
    //ka obrzku (1-144, 88 defaultn)
    $this->Width=ContentElement($this->$imagestring,"<width>","</width>");
    //vka obrzku (1-400, 31 defaultn)
    $this->Height=ContentElement($this->$imagestring,"<height>","</height>");
  }
}

//tda popisujc jednotliv poloky RSS kanlu
class clsItem {
  var $itemstring;
  //konstruktor, parametr je text elementu <item> vythnut z RSS souboru
  function clsItem($str) {
    $this->$itemstring=$str;

    //titulek poloky (max 100 zn.)
    $this->Title=ContentElement($this->$itemstring,"<title>","</title>");
    //link poloky (max 500 zn.)
    $this->Link=ContentElement($this->$itemstring,"<link>","</link>");
    //ukzka poloky (max 500 zn.)
    $this->Description=ContentElement($this->$itemstring,"<description>","</description>");
  }
}

?>